import { StarXpandCommand } from "star-io10-web";

export class LabelSample16_For203dpiAnd300dpi_ShelfLabelForInventory_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(48.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            // モデルにより対応する文字エンコーディング指定APIが異なります。
            // 下記ページのSupported Modelを参照し、ご利用のモデルが対応するAPIを使用してください。
            // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-cjk-character-priority.html
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-second-priority-character-encoding.html
            //.styleSecondPriorityCharacterEncoding(CharacterEncodingType.Japanese)

            // By setting the base print size of text to x1.5 for 300dpi,
            // you can print text at the same size as 203dpi.
            //.styleBaseMagnification(new BaseMagnificationParameter().setText(BaseMagnification.X1_5))
            .addPageMode(
              new StarXpandCommand.Printer.PageModeAreaParameter(48.0, 36.0),
              new StarXpandCommand.PageModeBuilder()
                .styleVerticalPositionTo(6.0)
                .add(
                  new StarXpandCommand.PageModeBuilder()
                    .styleMagnification(
                      new StarXpandCommand.MagnificationParameter(2, 2),
                    )
                    .actionPrintText("${name}"),
                )

                .styleHorizontalPositionTo(0.0)
                .styleVerticalPositionTo(15.0)
                .actionPrintQRCode(
                  new StarXpandCommand.Printer.QRCodeParameter("${sku}")
                    .setCellSize(4)
                    .setLevel(StarXpandCommand.Printer.QRCodeLevel.L)
                    .setModel(StarXpandCommand.Printer.QRCodeModel.Model2),
                )
                .addPageMode(
                  new StarXpandCommand.Printer.PageModeAreaParameter(35.0, 24.0)
                    .setX(12.0)
                    .setY(12.0),
                  new StarXpandCommand.PageModeBuilder().actionPrintText(
                    "${company}\n" +
                      "${note}\n" +
                      "使用材料名:${material}\n" +
                      "金型取数:${mold_cavities}\n" +
                      "整形場所:${molding_place}\n",
                  ),
                ),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "name" : "12345678 素材Ｓ",
    "sku" : "12345678素材Ｓ",
    "company" : "スター精密",
    "note" : "s1",
    "material" : "アクリル樹脂",
    "mold_cavities" : 1,
    "molding_place" : "Star Micronics"
}`,
    );
  }
}
